﻿using System;
using System.IO;

namespace CSharpBuch.Kap07
{
  public abstract class Logging
  {
    string log;

    public void Add(string logEintrag)
    {
      log = log + logEintrag;
    }

    public void Clear()
    {
      log = "";
    }

    public string LogInhalt()
    {
      return log;
    }

    public abstract void Save();
  }

  public class KonsoleLogging : Logging
  {
    public override void Save()
    {
      Console.WriteLine(LogInhalt());
    }
  }

  public class DateiLogging : Logging
  {
    private string dateiname;

    public DateiLogging(string dateiname)
    {
      this.dateiname = dateiname;
    }
    public override void Save()
    {
      StreamWriter sw = new StreamWriter(dateiname);
      sw.Write(LogInhalt());
      sw.Flush();
      sw.Close();
    }
  }
}