﻿using System;

namespace CSharpBuch.Kap07
{
  public class MethodenVersiegeln
  {
    static void Main(string[] args)
    {
      Person[] personen = new Person[3];
      personen[0] = new Person();
      personen[1] = new Mitarbeiter();
      personen[2] = new Dozent();

      foreach (Person p in personen)
        AusgabeDaten(p);
    }

    static void AusgabeDaten(Person p)
    {
      Console.WriteLine("*** " + p.GetType().ToString() + "***");
      p.Ausgabe();
      Console.WriteLine();
    }
  }

  public class Person
  {
    public virtual void Ausgabe()
    {
      Console.WriteLine("Name: Musterperson");
    }
  }

  public class Mitarbeiter : Person
  {
    public sealed override void Ausgabe()
    {
      base.Ausgabe();
      Console.WriteLine("Gehalt: 1000 Euro");
    }
  }

  public class Dozent : Mitarbeiter
  {
    new public void Ausgabe()
    {
      base.Ausgabe();
      Console.WriteLine("IQ: 113");
    }
  }
}