﻿using System;

namespace CSharpBuch.Kap07
{
  public class MitarbeiterMain
  {
    static void Main(string[] args)
    {
      Mitarbeiter ma = new Mitarbeiter();
      Console.WriteLine(ma.ZeigePerson());

      ma = new Mitarbeiter("Dr.", "Müller", "Heiko", "10.10.76", 1, 5000.00);
      Console.WriteLine(ma.ZeigePerson());
      Console.WriteLine("Neues Gehalt: " + ma.GehaltAendern(300.00));

      Student stud = new Student("Bauer", "Jana", "20.01.85", 456, "Informatik");
      Console.WriteLine(stud.ZeigePerson());

      Console.ReadLine();
    }
  }

  public class Person
  {
    private string name;
    private string vorname;
    private string gebdat;
    private int nummer;

    public Person() : this("", "", "", 0)
    {
      Console.WriteLine("1. Konstruktor von Person");
    }

    public Person(string name, string vorname, string gebdat, int nummer)
    {
      this.name = name;
      this.vorname = vorname;
      this.gebdat = gebdat;
      this.nummer = nummer;

      Console.WriteLine("2. Konstruktor von Person");
    }

    public string ZeigePerson()
    {
      if (name == "")
        return ("Keine Angaben vorhanden");
      else
        return (nummer + ": " + name + ", " + vorname + "; geboren am: " + gebdat);
    }
  }

  public class Mitarbeiter : Person
  {
    private string titel;
    private double gehalt;

    public Mitarbeiter()
    {
      titel = "";
      gehalt = 0;

      Console.WriteLine("1. Konstruktor von Mitarbeiter");
    }

    public Mitarbeiter(string titel, string name, string vorname,
                       string gebdat, int nummer, double gehalt) :
      base(name, vorname, gebdat, nummer)
    {
      this.titel = titel;
      this.gehalt = gehalt;

      Console.WriteLine("2. Konstruktor von Mitarbeiter");
    }

    public double GehaltAendern(double gehaltsErhoehung)
    {
      gehalt += gehaltsErhoehung;
      return (gehalt);
    }
  }

  public class Student : Person
  {
    private string studienrichtung;

    public Student(string name, string vorname, string gebdat, int nummer, string fach) : base(name, vorname, gebdat, nummer)
    {
      studienrichtung = fach;

      Console.WriteLine("Konstruktor von Student");
    }
  }
}