﻿using System;

namespace CSharpBuch.Kap07
{
  public class ObjectBasisklasse
  {
    static void Main(string[] args)
    {
      Test t1 = new Test();
      Test t2 = t1;
      Test t3 = new Test();

      if (Object.ReferenceEquals(t1, t2))
        Console.WriteLine("Gleiche Referenz: tl, t2");
      if (Object.ReferenceEquals(t1, t3))
        Console.WriteLine("Gleiche Referenz: t1, t3");

      if (t1.Equals(t2))
        Console.WriteLine("Gleich: t1, t2");
      if (t1.Equals(t3))
        Console.WriteLine("Gleich: t1, t3");

      Console.WriteLine("ToString(): " + t1.ToString());
      Console.WriteLine("HashCode(): " + t1.GetHashCode());
    }
  }

  public class Test
  {
    private string x = "test";
    private int y = 100;

    public override string ToString()
    {
      return String.Format("{0}:{1}", x, y);
    }

    public override int GetHashCode()
    {
      return base.GetHashCode() / 2;
    }

    public override bool Equals(object obj)
    {
      return (this.GetType() == obj.GetType()) &
             (this.GetHashCode() == obj.GetHashCode());
    }
  }
}
