﻿using System;

namespace CSharpBuch.Kap07
{
  public class VerschachtelteKlassen
  {
    static void Main(string[] args)
    {
      string s;

      StringListe sl = new StringListe();
      VorIterator iter = sl.GetVorIterator();

      while ((s = iter.GetNext()) != null)
        Console.WriteLine(s);
    }
  }

  public abstract class VorIterator
  {
    public abstract string GetNext();
  }

  public class StringListe
  {
    private string[] liste = { "Eintrag 1", "Eintrag 2", "Eintrag 3" };

    private class InternVor : VorIterator
    {
      private int index = -1;
      StringListe sl;

      public InternVor(StringListe sl)
      {
        this.sl = sl;
      }

      public override string GetNext()
      {
        index++;
        if (index < sl.liste.Length)
          return sl.liste[index];
        else
        {
          index = sl.liste.Length;
          return null;
        }
      }
    }

    public VorIterator GetVorIterator()
    {
      return new InternVor(this);
    }
  }
}