﻿using System;

namespace CSharpBuch.Kap07
{
  public class Zuweisungskompatibel
  {
    static void Main(string[] args)
    {
      Person p = new Person();
      Mitarbeiter ma = new Mitarbeiter();

      AusgabeDaten(p);
      AusgabeDaten(ma);
    }

    private static void AusgabeDaten(Person p)
    {
      p.Ausgabe();

      if (p is Mitarbeiter)
        (p as Mitarbeiter).AusgabeGehalt();
      
      Console.WriteLine(p.GetType().ToString());
    }
  }

  public class Person
  {
    public void Ausgabe()
    {
      Console.WriteLine("Musterperson");
    }
  }

  public class Mitarbeiter : Person
  {
    public void AusgabeGehalt()
    {
      Console.WriteLine("1000 Euro");
    }
  }
}