﻿using System;

namespace CSharpBuch.Kap08
{
  public class ManuelleBereinigung
  {
    static void Main(string[] args)
    {
      DBZugriff dbz = new DBZugriff();
      dbz.Close();

      if (dbz is IDisposable)
        (dbz as IDisposable).Dispose();

      Console.ReadLine();
    }
  }

  class DBZugriff : IDisposable
  {
    private bool disposeHandled = false;

    public DBZugriff()
    {
      Console.WriteLine("Objekt erzeugt...");
    }

    public void Close()
    {
      // ...
      Dispose();
    }

    public void Dispose()
    {
      Dispose(true);
      GC.SuppressFinalize(this);
    }

    protected virtual void Dispose(bool callDispose)
    {
      if (!disposeHandled)
      {
        Console.WriteLine("Objekt freigegeben...");
    
        if (callDispose)
        {
          // ... Managed-Objekte freigeben
        }
        
        // Dateien oder Datenbankverb. schließen
        disposeHandled = true;
      }
    }

    ~DBZugriff()
    {
      Dispose(false);
      Console.WriteLine("Destruktor von Objekt aufgerufen...");
    }
  }
}
