﻿using System;

namespace CSharpBuch.Kap09
{
  public enum FarbSchema : byte
  {
    Ocean = 1, Normal, Pink
  }

  public class SpezialAufzaehlungen
  {
    static void Main(string[] args)
    {
      FarbSchema fs = FarbSchema.Pink;

      Console.WriteLine("Methoden der Strukur Enum ...");
      Console.WriteLine("Format(): " + Enum.Format(typeof(FarbSchema), FarbSchema.Ocean, "G"));
      Console.WriteLine("GetName(): " + Enum.GetName(typeof(FarbSchema), fs));
      Console.WriteLine("Get(): " + Enum.GetUnderlyingType(typeof(FarbSchema)));
      
      if (Enum.IsDefined(typeof(FarbSchema), "Pink"))
      {
        Console.WriteLine("IsDefined(): Pink gibt's in FarbSchema");
        FarbSchema fs2 = (FarbSchema)Enum.Parse(typeof(FarbSchema), "Pink");
      }

      Console.WriteLine("\nAlle Namen der Aufzählungskonstanten: ");
      foreach (string s in Enum.GetNames(typeof(FarbSchema)))
        Console.WriteLine(s);

      Console.WriteLine("\nAlle Werte der Aufzählungskonstanten: ");
      foreach (byte b in Enum.GetValues(typeof(FarbSchema)))
        Console.WriteLine(b);
    }
  }
}