﻿using System;

namespace CSharpBuch.Kap10
{
  public class ArrayFunktionen
  {
    static void Main(string[] args)
    {
      Person[] personen = new Person[]
      { 
        new Person("Meier", 25),
        new Person("Schulze", 35),
        new Person("Krause", 45),
        new Person("Duck", 30)
      };

      Array.ForEach<Person>(personen, AlterFilter);

      Array.Sort(personen);
      foreach (Person p in personen)
        Console.WriteLine(p.Name);
    }

    private static void AlterFilter(Person p)
    {
      if (p.Alter < 35)
        Console.WriteLine("{0} hat 28 Tage Urlaub", p.Name);
      else
        Console.WriteLine("{0} hat 30 Tage Urlaub", p.Name);
    }
  }

  public class Person : IComparable
  {
    public string Name;
    public int Alter;

    public Person(string name, int alter)
    {
      Name = name;
      Alter = alter;
    }

    public int CompareTo(object obj)
    {
      return Name.CompareTo((obj as Person).Name);
    }
  }
}
