﻿using System;
using System.Text;

namespace CSharpBuch.Kap11
{
  public class ZeichenkettenVerbinden
  {
    const int iterationen = 20000;
    static string str = String.Empty;

    // Zusammensetzen mit +
    static void VerkettePlus(ref string str)
    {
      for (int i = 0; i < iterationen; i++)
        str += "Hallo" + i.ToString();
    }

    // Zusammensetzen mit Concat()
    static void VerketteConcat(ref string str)
    {
      for (int i = 0; i < iterationen; i++)
        str = String.Concat(str, "Hallo", i.ToString());
    }

    // Zusammensetzen mit StringBuilder
    static void VerketteStringBuilder(ref string str)
    {
      StringBuilder sb = new StringBuilder();

      for (int i = 0; i < iterationen; i++)
        sb.Append("Hallo" + i.ToString());

      str = sb.ToString();
    }

    static void Main(string[] args)
    {
      Console.WriteLine("Wählen Sie aus: \n"
          + "1 - Verkettung mit '+'\n"
          + "2 - Verkettung mit Concat()\n"
          + "3 - Verkettung mit StringBuilder\n"
          + "4 - Ende\n\n");

      ConsoleKeyInfo cki = Console.ReadKey(true); // Auf Benutzereingabe warten
      DateTime startZeit = DateTime.Now;          // Zeitmessung starten

      // Benutzereingabe auswerten
      switch (cki.Key)
      {
        case ConsoleKey.D1: VerkettePlus(ref str);
          break;
        case ConsoleKey.D2: VerketteConcat(ref str);
          break;
        case ConsoleKey.D3: VerketteStringBuilder(ref str);
          break;
        case ConsoleKey.D4: return;
      }

      DateTime endZeit = DateTime.Now; // Zeitmessung beenden
      TimeSpan differenz = endZeit.Subtract(startZeit); // Zeitmessung auswerten
      // Ausgabe
      Console.WriteLine("Schleifendurchläufe   : " + iterationen.ToString());
      Console.WriteLine("Länge der Zeichenkette: " + str.Length.ToString());
      Console.WriteLine("Benötigte Zeit (s)    : " + differenz.TotalSeconds.ToString());

      Console.ReadKey();
    }
  }
}