﻿using System;

namespace CSharpBuch.Kap13
{
  public delegate void KritischEventHandler(object sender, MessEventArgs e);

  public class MessEventArgs : EventArgs
  {
    public string Nachricht;
    public int Messwert;

    public MessEventArgs(string nachricht, int messwert)
    {
      Nachricht = nachricht;
      Messwert = messwert;
    }
  }

  public class Ereignisse
  {
    public void Handler(object sender, MessEventArgs e)
    {
      Console.WriteLine("Ereignis: {0}\nNachricht: {1} Wert: {2}\n\n",
                        sender, e.Nachricht, e.Messwert);
    }

    static void Main(string[] args)
    {
      Ereignisse ergs1 = new Ereignisse();
      Ereignisse ergs2 = new Ereignisse();
      Messfuehler mf = new Messfuehler();
      mf.Kritisch += ergs1.Handler;
      mf.Kritisch += ergs2.Handler;
      mf.PruefeWerte();
    }
  }

  public class Messfuehler
  {
    Random rd = new Random();

    public event KritischEventHandler Kritisch;

    protected virtual void OnKritisch(MessEventArgs e)
    {
      if (Kritisch != null)
        Kritisch(this, e);
    }

    public void PruefeWerte()
    {
      int messwert;
      for (int i = 0; i < 100; i++)
      {
        messwert = rd.Next(25);
        if (messwert > 20)
          OnKritisch(new MessEventArgs("Wert zu hoch", messwert));
      }
    }
  }
}