﻿using System;

namespace CSharpBuch.Kap13
{
  delegate void grosseWaesche(ref string waschLog);

  public class Waschprogramm
  {
    public void waschen(ref string waschLog)
    {
      waschLog += ", waschen";
    }

    public void buegeln(ref string waschLog)
    {
      waschLog += ", bügeln";
    }

    public void vorwaschen(ref string waschLog)
    {
      waschLog += ", vorwaschen";
    }

    public void trocknen(ref string waschLog)
    {
      waschLog += ", trocknen";
    }
  }

  public class MulticastDelegaten
  {

    static void Main(string[] args)
    {
      string log = null;

      Waschprogramm wp = new Waschprogramm();
      grosseWaesche gw1 = wp.waschen;
      grosseWaesche gw2 = wp.trocknen;
      grosseWaesche gw3 = wp.buegeln;

      grosseWaesche gw = gw1 + gw2 + gw3;
      gw(ref log);
      Console.WriteLine(log + "\n\n");

      gw = gw - gw1;
      log = "";
      gw(ref log);
      Console.WriteLine(log + "\n\n");

      gw = (grosseWaesche)Delegate.Remove(gw, gw2);
      log = "";
      gw(ref log);

      Console.WriteLine(log + "\n\n");
      Console.ReadLine();
    }
  }
}