﻿using System;

namespace CSharpBuch.Kap14
{
  public class EigeneExceptions
  {
    static void Main(string[] args)
    {
      try
      {
        throw new OutOfRangeException("Bumm", 10);
      }
      catch (OutOfRangeException oorEx)
      {
        Console.WriteLine(oorEx.Message);
        Console.WriteLine(oorEx.Index);
      }

      Console.ReadLine();
    }
  }

  public class OutOfRangeException : ApplicationException
  {
    public int Index = 0;

    public OutOfRangeException()
    {
    }

    public OutOfRangeException(string message) : base(message)
    {
    }
    
    public OutOfRangeException(string message, int index) : base(message)
    {
      Index = index;
    }

    public OutOfRangeException(string message, Exception inner) : base(message, inner)
    {
    }

    public OutOfRangeException(string message, Exception inner, int index) : base(message, inner)
    {
      Index = index;
    }

    public override string Message
    {
      get
      {
        return base.Message + ": Index außerhalb des gültigen Bereichs(" + Index + ")";
      }
    }
  }
}