﻿using System;

namespace CSharpBuch.Kap15
{
  [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = true)]
  public class ToDoAttribute : Attribute
  {
    private string autor;
    private string beschreibung;
    private int prio;

    public ToDoAttribute() : this("Dirk F.", "ToDo")
    {
    }

    public ToDoAttribute(string autor, string beschreibung)
    {
      this.autor = autor;
      this.beschreibung = beschreibung;
    }
    
    public string Autor
    {
      get { return autor; }
    }
    
    public string Beschreibung
    {
      get { return beschreibung; }
    }
    
    public int Prioritaet
    {
      get { return prio; }
      set { prio = value; }
    }
  }
}