﻿using System;
using System.Collections;

namespace CSharpBuch.Kap16
{
  public class IndividuelleSortierung
  {
    static void Main(string[] args)
    {
      ArrayList al = new ArrayList();

      al.Add(new Person("Meier", 25));
      al.Add(new Person("Schulze", 30));
      al.Add(new Person("Meier", 19));
      al.Add(new Person("Krause", 47));

      al.Sort(new PersonComparer());

      foreach (Person p in al)
        Console.WriteLine("Name: {0}, Alter: {1}", p.Name, p.Alter);
    }
  }

  public class PersonComparer : IComparer
  {
    public int Compare(object x, object y)
    {
      if ((x is Person) & (y is Person))
      {
        Person p1 = x as Person;
        Person p2 = y as Person;

        if (p1.Name == p2.Name)
          return p1.Alter.CompareTo(p2.Alter);
        else
          return p1.Name.CompareTo(p2.Name);
      }
      else
        throw new ApplicationException("Falsche Parametertypen");
    }
  }

  public class Person
  {
    public int Alter;
    public string Name;

    public Person(string name, int alter)
    {
      Alter = alter;
      Name = name;
    }
  }
}