﻿using System;
using System.Collections;

namespace CSharpBuch.Kap16
{
  public class PersonIterator
  {
    static void Main(string[] args)
    {
      PersonListe p1 = new PersonListe();
      foreach (Person p in p1)
        Console.WriteLine("Name: {0}, Alter: {1}", p.Name, p.Alter);

      Console.WriteLine("Und rückwärts ...");
      foreach (Person p in p1.GetReverseEnumerator())
        Console.WriteLine("Name: {0}, Alter: {1}", p.Name, p.Alter);
    }
  }

  public class Person
  {
    public int Alter;
    public string Name;

    public Person(string name, int alter)
    {
      Alter = alter;
      Name = name;
    }
  }

  public class PersonListe : IEnumerable
  {
    Person[] personen = { new Person("Meier", 25), 
                          new Person("Schulze", 35),
                          new Person("Krause", 45)};
    
    public IEnumerator GetEnumerator()
    {
      for (int i = 0; i < personen.Length; i++)
      {
        if (i < 2)
          yield return personen[i];
        else
          yield break;
      }
    }
    
    public IEnumerable GetReverseEnumerator()
    {
      for (int i = personen.Length - 1; i >= 0; i--)
        yield return personen[i];
    }
  }
}