﻿using System;
using System.Collections;

namespace CSharpBuch.Kap16
{
  public class TeileEnumerator
  {
    static void Main(string[] args)
    {
      foreach (string s in new MaschinenTeile())
        Console.WriteLine(s);
    }
  }

  public class MaschinenTeile : IEnumerable
  {
    string[] teile = { "Teil 1", "Teil 2", "Teil 3" };

    public IEnumerator GetEnumerator()
    {
      return new Lieferbar(this);
    }

    private class Lieferbar : IEnumerator
    {
      private int pos = -1;
      private MaschinenTeile mt;

      public Lieferbar(MaschinenTeile mt)
      {
        this.mt = mt;
      }
      public object Current
      {
        get
        {
          return mt.teile[pos];
        }
      }

      public bool MoveNext()
      {
        if (pos < mt.teile.Length - 1)
        {
          pos++;
          return true;
        }
        else
          return false;
      }

      public void Reset()
      {
        pos = -1;
      }
    }
  }
}