﻿using System;
using System.Collections.Generic;

namespace CSharpBuch.Kap17
{
  public class TypEinschraenkungen
  {
    static void Main(string[] args)
    {
      EinAusgabe ea = new EinAusgabe();
      TestEinAusgabe<EinAusgabe> tea = new TestEinAusgabe<EinAusgabe>();
      tea.Test(ea);
    }
  }

  public interface IEinAusgabe
  {
    void Ausgabe(string wert);
    string Eingabe();
  }

  public class EinAusgabe : IEinAusgabe
  {
    public void Ausgabe(string wert)
    {
      Console.WriteLine(wert);
    }

    public string Eingabe()
    {
      return Console.ReadLine();
    }
  }

  public class TestEinAusgabe<T> where T : IEinAusgabe
  {
    public void Test(T ea)
    {
      ea.Ausgabe("Geben Sie bitte etwas Text ein...");
      string s = ea.Eingabe();
      ea.Ausgabe(s);
      Console.ReadLine();
    }
  }
}