﻿using System;
using System.IO;

namespace CSharpBuch.Kap18
{
  public class DateiUeberwachung
  {
    FileSystemWatcher fsw = new FileSystemWatcher("C:\\");

    public void FSWEvent(object sender, FileSystemEventArgs fsea)
    {
      Console.WriteLine(fsea.ChangeType.ToString() + ":" + fsea.FullPath);
    }

    public void FSWEventRenamed(object sender, RenamedEventArgs rea)
    {
      Console.WriteLine(rea.ChangeType.ToString() + ":" + rea.FullPath);
    }

    public void ZeigeInfo()
    {
      fsw.Filter = "*.*";
      fsw.IncludeSubdirectories = true;
      fsw.Changed += FSWEvent;
      fsw.Created += FSWEvent;
      fsw.Deleted += FSWEvent;
      fsw.Renamed += FSWEventRenamed;
      fsw.EnableRaisingEvents = true;

      Console.WriteLine("Drücken Sie auf E zum Beenden!");
      while (Console.Read() != 'E')
        ;
    }

    static void Main(string[] args)
    {
      new DateiUeberwachung().ZeigeInfo();
    }
  }
}