﻿using System;
using System.IO;
using System.IO.IsolatedStorage;

namespace CSharpBuch.Kap18
{
  public class IsolierterSpeicher
  {
    static void Main(string[] args)
    {
      IsolatedStorageFile isoStore = IsolatedStorageFile.GetUserStoreForAssembly();
      Stream s = new IsolatedStorageFileStream("Logging.txt", FileMode.Create, isoStore);
      
      StreamWriter sw = new StreamWriter(s);
      
      sw.WriteLine("Anwendung wurde erfolgreich gestartet ...");
      sw.WriteLine("und auch erfolgreich beendet");
      
      sw.Flush();
      s.Close();

      Console.WriteLine("*** DateiListe ***");
      foreach (string datei in isoStore.GetFileNames("*.*"))
        Console.WriteLine(datei);
    }
  }
}