﻿using System;
using System.Collections;

namespace CSharpBuch.Kap18
{
  public class UmgebungsInfo
  {
    public void ZeigeInfo()
    {
      Console.WriteLine("Kommandozeile: " + Environment.CommandLine);
      Console.WriteLine("Aktuelles Arbeitsverzeichnis: " + Environment.CurrentDirectory);
      Console.WriteLine("Rechnername: " + Environment.MachineName);
      Console.WriteLine("Betriebssystemversion: " + Environment.OSVersion);
      Console.WriteLine("Systemverzeichnis: " + Environment.SystemDirectory);
      Console.WriteLine("Zeit in ms seit Systemstart: " + Environment.TickCount);
      Console.WriteLine("Benutzername: " + Environment.UserName);
      Console.WriteLine("Version des .NET Frameworks: " + Environment.Version);

      Console.WriteLine("\nKommandozeile: ");
      string[] kommandoZeile = Environment.GetCommandLineArgs();
      foreach (String k in kommandoZeile)
        Console.WriteLine(k);

      Console.WriteLine("\nListe der Umgebungsvariablen: ");
      IDictionary uvListe = Environment.GetEnvironmentVariables();
      foreach (DictionaryEntry de in uvListe)
        Console.WriteLine(de.Key + "=" + de.Value);

      Console.WriteLine("\nListe der logischen Laufwerke: ");
      string[] laufwerke = Environment.GetLogicalDrives();
      foreach (string lw in laufwerke)
        Console.WriteLine(lw);

      Console.WriteLine(" \nEigene Dateien: " + Environment.GetFolderPath(Environment.SpecialFolder.Personal));
      Console.WriteLine("Programm-Ordner: " + Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles));
    }

    static void Main(string[] args)
    {
      new UmgebungsInfo().ZeigeInfo();
      Console.ReadLine();
    }
  }
}