﻿using System;
using System.Text;

namespace CSharpBuch.Kap21
{
  public class ConsoleAnwendung
  {
    public static void Main(string[] args)
    {
      StringBuilder sb = new StringBuilder();
      
      Console.WriteLine("Fenstergröße: " + Console.WindowWidth + ", " + Console.WindowHeight);
      Console.WriteLine("Puffergröße: " + Console.BufferWidth + ", " + Console.BufferHeight);
      Console.WriteLine("Maximale Fenstergröße: {0}, {1}",
                        Console.LargestWindowWidth, Console.LargestWindowHeight);
      Console.WriteLine("\nWeiter mit beliebiger Taste");
      Console.Read();
      Console.SetBufferSize(80, 80);
      Console.SetWindowSize(80, 20);
      Console.BackgroundColor = ConsoleColor.Blue;
      Console.ForegroundColor = ConsoleColor.Green;
      Console.Title = "Kreuztabelle für Produkte zweier Zahlen";
      Console.Clear();
      
      for (int i = 1; i <= 25; i++)
      {
        for (int j = 1; j <= 5; j++)
          Console.Write("{0}\t", (i * j));
      
        Console.WriteLine();
      }

      Console.SetWindowPosition(0, 0);
      Console.CursorVisible = false;

      Console.ReadKey();
    }
  }
}