using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CSharpBuch.Kap23
{
  public partial class DialogfensterForm:Form
  {
    public DialogfensterForm()
    {
      InitializeComponent();
      lblTest.Text = "Schriftart: " + lblTest.Font.Name +
                     " Gre: " + lblTest.Font.Size;
      lblFarbe.Text = "Farbe: " + lblFarbe.ForeColor.Name;
    }

    private void btnSchriftart_Click(object sender, EventArgs e)
    {
      if (fontDialog1.ShowDialog() == DialogResult.OK)
      {
        lblTest.Font = fontDialog1.Font;
        lblFarbe.Font = fontDialog1.Font;
        lblTest.Text = "Schriftart: " + fontDialog1.Font.Name +
                       " Gre: " + fontDialog1.Font.Size;
      }
    }

    private void btnFarbe_Click(object sender, EventArgs e)
    {
      if (colorDialog1.ShowDialog() == DialogResult.OK)
      {
        lblFarbe.ForeColor = colorDialog1.Color;
        lblTest.ForeColor = colorDialog1.Color;
        lblFarbe.Text = "Farbe: " + colorDialog1.Color.Name;
      }
    }

    private void btnDatei_Click(object sender, EventArgs e)
    {
      if (openFileDialog1.ShowDialog() == DialogResult.OK)
        lblDatei.Text = "Datei: " + openFileDialog1.FileName;
    }

    private void btnEnde_Click(object sender, EventArgs e)
    {
      if (MessageBox.Show("Anwendung wirklich beenden?", "Beenden",
         MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
        Close();
    }

    private void btnIndividuell_Click(object sender, EventArgs e)
    {
      EigenerDialog ed = new EigenerDialog();
      DialogResult dr = ed.ShowDialog();
      switch (dr)
      {
        case DialogResult.OK: MessageBox.Show("OK geklickt"); break;
        case DialogResult.Cancel: MessageBox.Show("Abbrechen geklickt"); break;
        case DialogResult.Ignore: MessageBox.Show("Ignorieren geklickt"); break;
        case DialogResult.Yes: MessageBox.Show("Ja geklickt"); break;
      }
    }
  }
}