using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CSharpBuch.Kap23
{
  public partial class EditorForm:Form
  {
    public EditorForm()
    {
      InitializeComponent();
    }

    private void ffnenToolStripMenuItem_Click(object sender, EventArgs e)
    {
      openFileDialog1.Filter = "Textdateien (*.txt)|*.txt|RTF-Dateien (*.rtf)|*.rtf";
      if (openFileDialog1.ShowDialog() == DialogResult.OK)
      {
        if (openFileDialog1.FilterIndex == 1)
          txtBox.LoadFile(openFileDialog1.FileName,
                          RichTextBoxStreamType.PlainText);
        else
          txtBox.LoadFile(openFileDialog1.FileName,
                          RichTextBoxStreamType.RichText);
        Text = openFileDialog1.FileName + " wird editiert";
      }
    }

    private void toolStripMenuItem1_Click(object sender, EventArgs e)
    {
      if (txtBox.Text != "")
      {
        if (MessageBox.Show("nderungen des Textes speichern?", "Speichern?", MessageBoxButtons.YesNo) == DialogResult.Yes)
          speichernToolStripMenuItem_Click(sender, e);
      }
      txtBox.Text = "";
      Text = "Neuer Text";
      speichernToolStripMenuItem.Enabled = false;
    }

    private void speichernToolStripMenuItem_Click(object sender, EventArgs e)
    {
      saveFileDialog1.Filter = "Textdateien (*.txt)|*.txt|RTF-Dateien (*.rtf)|*.rtf";
      if (saveFileDialog1.ShowDialog() == DialogResult.OK)
      {
        if (saveFileDialog1.FilterIndex == 1)
          txtBox.SaveFile(saveFileDialog1.FileName,
                          RichTextBoxStreamType.PlainText);
        else
          txtBox.SaveFile(saveFileDialog1.FileName,
                          RichTextBoxStreamType.RichText);
        Text = saveFileDialog1.FileName + " wird editiert";
      }
    }

    private void schlieenToolStripMenuItem1_Click(object sender, EventArgs e)
    {
      if (txtBox.Text != "")
      {
        if (MessageBox.Show("nderungen des Textes speichern?", "Speichern?", MessageBoxButtons.YesNo) == DialogResult.Yes)
          speichernToolStripMenuItem_Click(sender, e);
      }
      Application.Exit();
    }

    private void ausschneidenToolStripMenuItem_Click(object sender, EventArgs e)
    {
      txtBox.Cut();
    }

    private void kopierenToolStripMenuItem_Click(object sender, EventArgs e)
    {
      txtBox.Copy();
    }

    private void einfgenToolStripMenuItem_Click(object sender, EventArgs e)
    {
      txtBox.Paste();
    }

    private void txtBox_TextChanged(object sender, EventArgs e)
    {
      speichernToolStripMenuItem.Enabled = true;
    }

    private void zeichenToolStripMenuItem_Click(object sender, EventArgs e)
    {
      if (fontDialog1.ShowDialog() == DialogResult.OK)
        txtBox.Font = fontDialog1.Font;
    }

    private void hilfeToolStripMenuItem2_Click(object sender, EventArgs e)
    {
      MessageBox.Show("Wenn Sie Hilfe zu diesem Produkt brauchen\n\n" +
                      " wenden Sie sich an den Hersteller", "Hilfe", MessageBoxButtons.OK, MessageBoxIcon.Question);
    }

    private void infoToolStripMenuItem_Click(object sender, EventArgs e)
    {
      MessageBox.Show("Texteditor \n\n Version 1.0.0", "Info", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
    }

    private void tsListe_TextChanged(object sender, EventArgs e)
    {
      switch (tsListe.SelectedIndex)
      {
        case 0:
          txtBox.Font = new Font(new FontFamily("Arial"), txtBox.Font.Size, txtBox.Font.Style);
                        break;
        case 1:
          txtBox.Font = new Font(new FontFamily("Courier New"), txtBox.Font.Size, txtBox.Font.Style);
                        break;
        case 2:
          txtBox.Font = new Font(new FontFamily("Times New Roman"), txtBox.Font.Size, txtBox.Font.Style);
                        break;
      }
    }

    private void rotToolStripMenuItem_Click(object sender, EventArgs e)
    {
      txtBox.BackColor = Color.LightBlue;
    }

    private void gelbToolStripMenuItem_Click(object sender, EventArgs e)
    {
      txtBox.BackColor = Color.Yellow;
    }

    private void grnToolStripMenuItem_Click(object sender, EventArgs e)
    {
      txtBox.BackColor = Color.LightGreen;
    }
  }
}
