﻿using System;
using System.Windows.Forms;

namespace CSharpBuch.Kap23
{
  static class MenueErstellen
  {
    [STAThread]
    static void Main()
    {
      Application.Run(new MnuForm());
    }
  }
  public class MnuForm:Form
  {
    // Menu und Menüpunkte erzeugen
    MainMenu mnu = new MainMenu();
    MenuItem mnuItem1 = new MenuItem("&Datei");
    MenuItem mnuItem11 = new MenuItem("&Neu");
    MenuItem mnuItem12 = new MenuItem("Ö&ffnen");
    MenuItem mnuItem13 = new MenuItem("&Speichern");
    MenuItem mnuItem14 = new MenuItem("-");
    MenuItem mnuItem15 = new MenuItem("&Beenden");
    MenuItem mnuItem2 = new MenuItem("&Bearbeiten");
    MenuItem mnuItem21 = new MenuItem("Ausschnei&den");
    MenuItem mnuItem22 = new MenuItem("&Kopieren");
    MenuItem mnuItem23 = new MenuItem("E&infügen");

    RichTextBox txtBox = new RichTextBox();
    OpenFileDialog openDlg = new OpenFileDialog();
    SaveFileDialog saveDlg = new SaveFileDialog();

    public MnuForm()
    {
      // Eigenschaften der Menüpunkte festlegen
      mnuItem21.Shortcut = Shortcut.CtrlX;
      mnuItem22.Shortcut = Shortcut.CtrlC;
      mnuItem23.Shortcut = Shortcut.CtrlV;
      mnuItem13.Enabled = false;

      // Menü zusammensetzen
      mnu.MenuItems.Add(mnuItem1);
      mnuItem1.MenuItems.Add(mnuItem11);
      mnuItem1.MenuItems.Add(mnuItem12);
      mnuItem1.MenuItems.Add(mnuItem13);
      mnuItem1.MenuItems.Add(mnuItem14);
      mnuItem1.MenuItems.Add(mnuItem15);
      mnu.MenuItems.Add(mnuItem2);
      mnuItem2.MenuItems.Add(mnuItem21);
      mnuItem2.MenuItems.Add(mnuItem22);
      mnuItem2.MenuItems.Add(mnuItem23);
      this.Menu = mnu;
      // EventHandler hinzufügen
      mnuItem11.Click += new EventHandler(mnu11_Click);
      mnuItem12.Click += new EventHandler(mnu12_Click);
      mnuItem13.Click += new EventHandler(mnu13_Click);
      mnuItem15.Click += new EventHandler(mnu15_Click);
      mnuItem21.Click += new EventHandler(mnu21_Click);
      mnuItem22.Click += new EventHandler(mnu22_Click);
      mnuItem23.Click += new EventHandler(mnu23_Click);
      //Textbox einfügen
      txtBox.Dock = DockStyle.Fill;
      txtBox.TextChanged += new EventHandler(txtBox_textChanged);
      this.Controls.Add(txtBox);
      Text = "Editor";
    }
    void mnu11_Click(object sender, EventArgs e)
    {
      // Datei neu anlegen 
      if (txtBox.Text != "")
      {
        if (MessageBox.Show("Änderungen des Textes speichern?", "Speichern?", MessageBoxButtons.YesNo) == DialogResult.Yes)
          mnu13_Click(sender, e);
      }
      txtBox.Text = "";
      Text = "Neuer Text";
      mnuItem13.Enabled = false;
    }
    void mnu12_Click(object sender, EventArgs e)
    {
      // Datei öffnen 
      openDlg.Filter = "Textdateien (*.txt)|*.txt|RTF-Dateien (*.rtf)|*.rtf";
      if (openDlg.ShowDialog() == DialogResult.OK)
        if (openDlg.FilterIndex == 1)
          txtBox.LoadFile(openDlg.FileName,
                          RichTextBoxStreamType.PlainText);
        else
          txtBox.LoadFile(openDlg.FileName,
                          RichTextBoxStreamType.RichText);
      Text = openDlg.FileName + " wird editiert";
    }
    void mnu13_Click(object sender, EventArgs e)
    {
      // Datei speichern
      saveDlg.Filter = "Textdateien (*.txt)|*.txt|RTF-Dateien (*.rtf)|*.rtf";
      if (saveDlg.ShowDialog() == DialogResult.OK)
        if (saveDlg.FilterIndex == 1)
          txtBox.SaveFile(saveDlg.FileName,
                          RichTextBoxStreamType.PlainText);
        else
          txtBox.SaveFile(saveDlg.FileName,
                          RichTextBoxStreamType.RichText);
      Text = saveDlg.FileName + " wird editiert";
    }
    void mnu15_Click(object sender, EventArgs e)
    {
      // Anwendung beenden
      Application.Exit();
    }
    void mnu21_Click(object sender, EventArgs e)
    {
      // Ausschneiden 
      txtBox.Cut();
    }
    void mnu22_Click(object sender, EventArgs e)
    {
      // Kopieren
      txtBox.Copy();
    }
    void mnu23_Click(object sender, EventArgs e)
    {
      // Einfügen 
      txtBox.Paste();
    }
    void txtBox_textChanged(object sender, EventArgs e)
    {
      mnuItem13.Enabled = true;
    }
  }
}
