﻿using System;
using System.Windows.Forms;

namespace CSharpBuch.Kap23
{
  static class MenueErstellen_Neu
  {
    [STAThread]
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new MnuForm());
    }
  }
  public class MnuForm:Form
  {
    // Menu und Menüpunkte erzeugen
    MenuStrip mnu;
    ToolStripMenuItem mnuItem1;
    ToolStripMenuItem mnuItem11;
    ToolStripMenuItem mnuItem12;
    ToolStripMenuItem mnuItem13;
    ToolStripSeparator mnuItem14;
    ToolStripMenuItem mnuItem15;
    ToolStripMenuItem mnuItem2;
    ToolStripMenuItem mnuItem21;
    ToolStripMenuItem mnuItem22;
    ToolStripMenuItem mnuItem23;

    RichTextBox txtBox;
    OpenFileDialog openDlg;
    SaveFileDialog saveDlg;

    public MnuForm()
    {
      this.SuspendLayout();
      
      mnu = new MenuStrip();
      mnuItem1 = new ToolStripMenuItem("&Datei");
      mnuItem11 = new ToolStripMenuItem("&Neu");
      mnuItem12 = new ToolStripMenuItem("Ö&ffnen");
      mnuItem13 = new ToolStripMenuItem("&Speichern");
      mnuItem14 = new ToolStripSeparator();
      mnuItem15 = new ToolStripMenuItem("&Beenden");
      mnuItem2 = new ToolStripMenuItem("&Bearbeiten");
      mnuItem21 = new ToolStripMenuItem("Ausschnei&den");
      mnuItem22 = new ToolStripMenuItem("&Kopieren");
      mnuItem23 = new ToolStripMenuItem("E&infügen");

      // Eigenschaften der Menüpunkte festlegen
      mnuItem21.ShortcutKeys = Keys.Control | Keys.X;
      mnuItem22.ShortcutKeys = Keys.Control | Keys.C;
      mnuItem23.ShortcutKeys = Keys.Control | Keys.V;
      mnuItem13.Enabled = false;
      try
      {
        mnuItem11.Image = System.Drawing.Bitmap.FromFile("images\\Neu.bmp");
        mnuItem12.Image = System.Drawing.Bitmap.FromFile("images\\Oeffnen.bmp");
        mnuItem13.Image = System.Drawing.Bitmap.FromFile("images\\Speichern.bmp");
        mnuItem15.Image = System.Drawing.Bitmap.FromFile("images\\Beenden.bmp");
        mnuItem21.Image = System.Drawing.Bitmap.FromFile("images\\Schere.bmp");
        mnuItem22.Image = System.Drawing.Bitmap.FromFile("images\\Kopieren.bmp");
        mnuItem23.Image = System.Drawing.Bitmap.FromFile("images\\Einfuegen.bmp");
      }
      catch (Exception e)
      {
        MessageBox.Show("Das Bild: " + e.Message + " fehlt.");
      }

      // Menü zusammensetzen
      mnu.Items.AddRange(new ToolStripItem[] { mnuItem1, mnuItem2 });
      mnuItem1.DropDownItems.AddRange(new ToolStripItem[] { mnuItem11, mnuItem12, mnuItem13, mnuItem14, mnuItem15 });
      mnuItem2.DropDownItems.AddRange(new ToolStripItem[] { mnuItem21, mnuItem22, mnuItem23 });
      mnu.Dock = DockStyle.Top;

      // EventHandler hinzufügen
      mnuItem11.Click += new EventHandler(mnu11_Click);
      mnuItem12.Click += new EventHandler(mnu12_Click);
      mnuItem13.Click += new EventHandler(mnu13_Click);
      mnuItem15.Click += new EventHandler(mnu15_Click);
      mnuItem21.Click += new EventHandler(mnu21_Click);
      mnuItem22.Click += new EventHandler(mnu22_Click);
      mnuItem23.Click += new EventHandler(mnu23_Click);

      // Textbox-Eigenschaften festlegen 
      txtBox = new RichTextBox();
      txtBox.Location = new System.Drawing.Point(1, 24);
      txtBox.Dock = DockStyle.Fill;
      txtBox.Size = new System.Drawing.Size(290, 300);
      txtBox.TextChanged += new EventHandler(txtBox_textChanged);

      // Formular zusammensetzen
      this.Size = new System.Drawing.Size(300, 350);
      this.Controls.Add(txtBox);
      this.Controls.Add(mnu);
      this.MainMenuStrip = mnu;
      this.Text = "Editor";
      this.ResumeLayout(false);
      this.PerformLayout();

      // Dialoge erzeugen
      openDlg = new OpenFileDialog();
      saveDlg = new SaveFileDialog();
    }
    void mnu11_Click(object sender, EventArgs e)
    {
      // Datei neu anlegen 
      if (txtBox.Text != "")
      {
        if (MessageBox.Show("Änderungen des Textes speichern?", "Speichern?", MessageBoxButtons.YesNo) == DialogResult.Yes)
          mnu13_Click(sender, e);
      }
      txtBox.Text = "";
      this.Text = "Neuer Text";
      mnuItem13.Enabled = false;
    }
    void mnu12_Click(object sender, EventArgs e)
    {
      // Datei öffnen 
      openDlg.Filter = "Textdateien (*.txt)|*.txt|RTF-Dateien (*.rtf)|*.rtf";
      if (openDlg.ShowDialog() == DialogResult.OK)
      {
        if (openDlg.FilterIndex == 1)
          txtBox.LoadFile(openDlg.FileName,
                          RichTextBoxStreamType.PlainText);
        else
          txtBox.LoadFile(openDlg.FileName,
                          RichTextBoxStreamType.RichText);
        this.Text = openDlg.FileName + " wird editiert";
      }
    }
    void mnu13_Click(object sender, EventArgs e)
    {
      // Datei speichern 
      saveDlg.Filter = "Textdateien (*.txt)|*.txt|RTF-files (*.rtf)|*.rtf";
      if (saveDlg.ShowDialog() == DialogResult.OK)
      {
        if (saveDlg.FilterIndex == 1)
          txtBox.SaveFile(saveDlg.FileName,
                          RichTextBoxStreamType.PlainText);
        else
          txtBox.SaveFile(saveDlg.FileName,
                          RichTextBoxStreamType.RichText);
        this.Text = saveDlg.FileName + " wird editiert";
      }
    }
    void mnu15_Click(object sender, EventArgs e)
    {
      // Anwendung beenden
      Application.Exit();
    }
    void mnu21_Click(object sender, EventArgs e)
    {
      // Ausschneiden 
      txtBox.Cut();
    }
    void mnu22_Click(object sender, EventArgs e)
    {
      // Kopieren
      txtBox.Copy();
    }
    void mnu23_Click(object sender, EventArgs e)
    {
      // Einfügen 
      txtBox.Paste();
    }
    void txtBox_textChanged(object sender, EventArgs e)
    {
      mnuItem13.Enabled = true;
    }
  }
}