﻿using System;
using System.Windows.Forms;
using System.Drawing;
using System.IO;

namespace CSharpBuch.Kap24
{
  static class BildAnzeigen
  {
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new BilderForm());
    }
  }

  class BilderForm:Form
  {
    PictureBox picBox;
    Button btn;
    String titel = "Bilder anzeigen";
    int i;

    public BilderForm()
    {
      picBox = new PictureBox();
      try
      {
        picBox.Image = Bitmap.FromFile("Nelly.jpg");
        // oder picBox.Image = new Bitmap("Nelly.jpg");
      }
      catch (FileNotFoundException e)
      {
        MessageBox.Show("Datei nicht gefunden: " + e.Message);
      }

      picBox.Location = new Point(10, 10);
      picBox.Size = new Size(400, 480);
      picBox.SizeMode = PictureBoxSizeMode.Zoom;
      picBox.BackColor = Color.Violet;
      picBox.BorderStyle = BorderStyle.FixedSingle;

      btn = new Button();
      btn.Text = "Grafikanzeige ändern";
      btn.Dock = DockStyle.Bottom;
      btn.Click += new EventHandler(btn_Click);

      this.ClientSize = new Size(460, 560);
      this.Controls.Add(picBox);
      this.Controls.Add(btn);
      this.Text = titel;

      i = 1;
    }

    private void btn_Click(object sender, EventArgs e)
    {
      switch (i)
      {
        case 0:
          picBox.SizeMode = PictureBoxSizeMode.Zoom;
          this.Text = titel + " Zoom";
          i = 1;
          break;
        case 1:
          picBox.SizeMode = PictureBoxSizeMode.StretchImage;
          this.Text = titel + " StretchImage";
          i = 2;
          break;
        case 2:
          picBox.SizeMode = PictureBoxSizeMode.CenterImage;
          this.Text = titel + " CenterImage";
          i = 3;
          break;
        case 3:
          picBox.SizeMode = PictureBoxSizeMode.Normal;
          this.Text = titel + " Normal";
          i = 4;
          break;
        case 4:
          picBox.SizeMode = PictureBoxSizeMode.AutoSize;
          this.Text = titel + " AutoSize";
          i = 0;
          picBox.Size = new Size(400, 480);
          break;
      }
    }
  }
}