﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace CSharpBuch.Kap24
{
  static class GrafikProgram
  {
    [STAThread]
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new Zeichnen());
    }
  }
  public class Zeichnen:Form
  {
    public Zeichnen()
    {
      this.ClientSize = new Size(500, 500);
      this.BackColor = Color.White;
      this.Text = "Grafik anzeigen";
    }

    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      Graphics g = e.Graphics;

      // verschiedene Linien
      Color c = Color.FromArgb(255, 100, 200, 100);
      Pen pen = new Pen(c, 10);
      g.DrawLine(pen, new Point(10, 10), new Point(200, 10));
      pen.DashStyle = DashStyle.Dash;
      g.DrawLine(pen, new Point(10, 30), new Point(200, 30));
      pen.DashCap = DashCap.Round;
      g.DrawLine(pen, new Point(10, 50), new Point(200, 50));
      pen.DashStyle = DashStyle.DashDot;
      pen.DashCap = DashCap.Triangle;
      g.DrawLine(pen, new Point(10, 70), new Point(200, 70));
      g.DrawLine(pen, new Point(10, 90), new Point(10, 90));

      // transparente Rechtecke
      Brush b;
      c = Color.FromArgb(100, Color.Red);
      b = new SolidBrush(c);
      g.FillRectangle(b, new Rectangle(10, 100, 100, 70));
      c = Color.FromArgb(100, Color.Blue);
      b = new SolidBrush(c);
      g.FillRectangle(b, new Rectangle(50, 130, 100, 70));

      // Farbverläufe
      b = new LinearGradientBrush(new Point(0, 0), new Point(50, 50), Color.Blue, Color.LightGreen);
      g.FillRectangle(b, new Rectangle(250, 10, 200, 100));

      b = new LinearGradientBrush(new Rectangle(0, 0, 50, 50), Color.BlueViolet, Color.LightPink, 20); //LinearGradientMode.Horizontal);
      g.FillRectangle(b, new Rectangle(250, 120, 200, 100));

      // selbst defineirter Farbverlauf
      Point[] ps = { new Point(50, 310), new Point(150, 310), new Point(200, 380), new Point(150, 440), new Point(50, 440), new Point(0, 380) };
      PathGradientBrush pgb = new PathGradientBrush(ps);
      pgb.CenterColor = Color.Green;
      pgb.CenterPoint = new Point(70, 390);
      g.FillRectangle(pgb, new Rectangle(0, 310, 500, 500));
    }
  }
}