using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace CSharpBuch.Kap24
{
  class GrafikenGlaetten
  {
    [STAThread]
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new Form1());
    }
  }
  public class Form1:Form
  {
    public Form1()
    {
      this.ClientSize = new Size(250, 140);
      this.BackColor = Color.White;
      this.Text = "Grafik anzeigen";
      this.SizeChanged += new EventHandler(zeichnen7_SizeChanged);
    }

    private void zeichnen7_SizeChanged(object sender, EventArgs e)
    {
      this.Refresh();
    }

    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      Graphics g = e.Graphics;
      Pen p = new Pen(Color.CadetBlue, 2);
      g.DrawLine(p, this.Width - 8, 0, 0, this.Height - 34);
      g.DrawEllipse(p, 55, 15, 40, 40);
      g.SmoothingMode = SmoothingMode.AntiAlias;
      g.DrawLine(p, 0, 0, this.Width - 8, this.Height - 34);
      g.DrawEllipse(p, 5, 15, 40, 40);
    }
  }
}
