﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace CSharpBuch.Kap24
{
  static class GrafikProgram2
  {
    [STAThread]
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new Zeichnen());
    }
  }
  public class Zeichnen:Form
  {
    public Zeichnen()
    {
      this.ClientSize = new Size(900, 200);
      this.BackColor = Color.White;
      this.Text = "Grafik anzeigen";
    }

    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      Graphics g = e.Graphics;
      Pen pen = new Pen(Color.Blue, 4);

      // mehrere Rechtecke
      Rectangle[] rs = { new Rectangle(20, 20, 50, 70), new Rectangle(50, 50, 50, 70), new Rectangle(80, 80, 50, 70) };
      g.DrawRectangles(pen, rs);
      
      // Ellipse im Rechteck
      Rectangle re = new Rectangle(150, 20, 80, 50);
      g.FillEllipse(Brushes.LightGreen, re);
      g.DrawRectangle(new Pen(Color.Black), re);
      
      // Kreis mit Radius
      pen.Width = 2;
      re = new Rectangle(200, 100, 80, 80);
      g.DrawEllipse(pen, re);
      g.DrawEllipse(pen, new Rectangle(239, 139, 2, 2));  // Mittelpunkt
      Point[] rad = { new Point(240, 100), new Point(240, 140), new Point(280, 140) };
      g.DrawLines(Pens.DarkBlue, rad);
      
      // roter Bogen auf dem Kreis
      pen.Color = Color.Red;
      g.DrawArc(pen, re, 270, 90);
      
      // Cardinal-Splinekurve
      Point[] ps = { new Point(300, 80), new Point(330, 30), new Point(340, 120), new Point(370, 50), new Point(400, 160), new Point(430, 30), new Point(460, 100) };
      g.FillClosedCurve(Brushes.LightBlue, ps, FillMode.Winding, 0.9f);
      pen.Color = Color.Blue;
      g.DrawCurve(pen, ps, 0.9f);
      g.DrawLines(Pens.Red, ps);
      
      // verbundene Linien
      GraphicsPath gp = new GraphicsPath();
      gp.StartFigure();
      gp.AddLine(new Point(500, 60), new Point(670, 100));
      gp.AddLine(new Point(670, 100), new Point(610, 130));
      gp.CloseFigure();
      g.DrawPath(pen, gp);
      
      // gefüllte Region
      Region r = new Region(gp);
      g.FillRegion(Brushes.LightGreen, r);
      
      // Füllmuster
      Brush b = new HatchBrush(HatchStyle.ForwardDiagonal, Color.Beige);
      g.FillRectangle(b, new Rectangle(700, 10, 130, 50));
      b = new HatchBrush(HatchStyle.Wave,
                   Color.PowderBlue, Color.Blue);
      g.FillRectangle(b, new Rectangle(700, 70, 130, 50));
      b = new TextureBrush(Image.FromFile("Kachel.bmp"));
      g.FillRectangle(b, new Rectangle(700, 130, 130, 60));
    }
  }
}