using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace CSharpBuch.Kap24
{
  static class GrafikTextAnzeigen
  {
    [STAThread]
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new Form1());
    }
  }
  public class Form1:Form
  {
    Button btnFont;
    Font font;
    public Form1()
    {
      font = new Font("Arial", 12);

      btnFont = new Button();
      btnFont.Text = "Font ndern";
      btnFont.Click += new EventHandler(btnFont_Click);

      this.ClientSize = new Size(800, 220);
      this.BackColor = Color.White;
      this.Text = "Grafik anzeigen";
      this.Controls.Add(btnFont);
    }

    private void btnFont_Click(object sender, EventArgs e)
    {
      FontDialog f = new FontDialog();
      f.Font = font;
      if (f.ShowDialog() == DialogResult.OK)
      {
        font = f.Font;
        this.Refresh();
      }
    }

    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      Graphics g = e.Graphics;
      String s = "Font: " + font.Name + " Gre: " + font.Size +
                 " Schriftschnitt: " + (font.Bold ? "Fett " : "") +
                 (font.Italic ? "Kursiv " : "");
      g.DrawString(s, font, Brushes.Black, new Point(10, 30));
      g.DrawString(s, font, Brushes.Blue, new Rectangle(10, 80, 500, 60));
      g.DrawRectangle(Pens.LightBlue, new Rectangle(10, 80, 500, 60));
      StringFormat sf = new StringFormat();
      sf.Alignment = StringAlignment.Far;
      sf.FormatFlags = StringFormatFlags.NoClip;
      g.DrawString(s, font, Brushes.BlueViolet, new Rectangle(10, 150, 500, 60), sf);
      g.DrawRectangle(Pens.BlueViolet, new Rectangle(10, 150, 500, 60));
    }
  }
}