using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace CSharpBuch.Kap24
{
  static class GrafikTransformationen1
  {
    [STAThread]
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new Form1());
    }
  }
  public class Form1:Form
  {
    public Form1()
    {
      this.ClientSize = new Size(800, 300);
      this.BackColor = Color.White;
      this.Text = "Grafiken verschieben, vergrern und drehen";
    }

    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      Graphics g = e.Graphics;
      Font f = new Font("Arial", 10f);
      Point p1 = new Point(50, 10);
      int a = 0;
      Rectangle r = new Rectangle(p1, new Size(100, 30));
      g.DrawRectangle(Pens.Green, r);
      g.DrawString(" A" + a, f, Brushes.Green, r);
      for (int i = 0; i < 5; i++)
      {
        g.TranslateTransform(110, 20);
        g.DrawRectangle(Pens.Red, r);
        g.DrawString(" A" + ++a, f, Brushes.Red, r);
      }
      // Koordinatenursprung zurckverschieben auf linke obere Ecke
      g.TranslateTransform(-550, -100);
      r = new Rectangle(50, 50, 50, 50);
      a = 0;
      g.DrawRectangle(Pens.Green, r);
      g.DrawString(" B" + a, f, Brushes.Green, r);
      for (int i = 0; i < 5; i++)
      {
        g.ScaleTransform(1.2f, 1.2f);
        g.DrawRectangle(Pens.Red, r);
        g.DrawString(" B" + ++a, f, Brushes.Red, r);
      }
      g.ScaleTransform(0.4f, 0.4f);
      g.TranslateTransform(380, 200);
      r = new Rectangle(5, 5, 80, 40);
      a = 0;
      f = new Font("Arial", 14f, FontStyle.Bold);
      g.DrawRectangle(Pens.Blue, r);
      g.DrawString("         C" + a, f, Brushes.Blue, r);
      for (int i = 0; i < 7; i++)
      {
        g.RotateTransform(45);
        g.DrawRectangle(Pens.Red, r);
        g.DrawString("         C" + ++a, f, Brushes.Red, r);
      }
    }
  }
}
