using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace CSharpBuch.Kap24
{
  static class GrafikTransformationen2
  {
    [STAThread]
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new Form1());
    }
  }
  public class Form1:Form
  {
    public Form1()
    {
      this.ClientSize = new Size(800, 220);
      this.BackColor = Color.White;
      this.Text = "Grafik scheren";
    }

    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      Graphics g = e.Graphics;
      Point p1 = new Point(50, 10);
      Rectangle r = new Rectangle(p1, new Size(100, 40));
      Matrix m = new Matrix();

      g.DrawRectangle(Pens.Green, r);
      g.DrawString("Textausgabe", new Font("Arial", 10f), Brushes.Green, r);
      m.Translate(101, -25);
      m.Shear(0, 0.5f);
      g.Transform = m;
      g.FillRectangle(Brushes.Yellow, r);
      g.DrawString("Textausgabe", new Font("Arial", 10f), Brushes.Red, r);

      m.Translate(101, 25);
      m.Shear(0, -0.5f);
      g.Transform = m;
      g.DrawRectangle(Pens.Green, r);
      g.DrawString("Textausgabe", new Font("Arial", 10f), Brushes.Green, r);

      m.Translate(51, 50);
      m.Shear(0, -0.5f);
      g.Transform = m;
      m.Translate(p1.X, 0);
      g.Transform = m;
      g.FillRectangle(Brushes.Yellow, r);
      g.DrawString("Textausgabe", new Font("Arial", 10f), Brushes.Red, r);
    }
  }
}