using System;
using System.ComponentModel;

namespace CSharpBuch.Kap25
{
  public class GradBogenUmrechner: Component
  {
    private double wert;
    private bool gradInBogen;

    [Category("Data"), Description("Ausgangswert fr die Umrechnung")]
    public double Wert
    {
      get
      {
        return wert;
      }
      set
      {
        wert = value;
      }
    }

    [Category("Data"), Description("Richtung der Umrechnung: true - Grad in Bogen, false - Bogen in Grad")]
    public bool UmrechnungGradInBogen
    {
      get
      {
        return gradInBogen;
      }
      set
      {
        gradInBogen = value;
      }
    }

    [Description("Rechnet Bogenma in Gradma um, je nach Eigenschaft UmrechnungGradInBogen")]
    public double Umrechnung()
    {
      if (gradInBogen)
        return wert * (Math.PI / 180);
      else
        return wert / (Math.PI / 180);
    }
  }
}