using System;
using System.Windows.Forms;
using System.Drawing;
using System.ComponentModel;

namespace CSharpBuch.Kap25
{
  public delegate void ZeitChangedEventHandler(object sender, EventArgs e);

  public class ZeitAnzeige:Control
  {
    DateTime zeit;
    Timer t;

    public ZeitAnzeige()
    {
      this.BackColor = Color.Black;
      this.ForeColor = Color.LightGreen;
      this.MinimumSize = new Size(100, 23);
      zeit = DateTime.Now;
      t = new Timer();
      t.Interval = 1000;
      t.Tick += new System.EventHandler(this.t_Tick);
      t.Start();
    }

    new void Dispose()
    {
      base.Dispose();
      t.Stop();
    }

    private void t_Tick(object sender, EventArgs e)
    {
      zeit = zeit.AddSeconds(1);
      OnZeitChanged(new EventArgs());
      this.Refresh();
    }


    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      ControlPaint.DrawBorder(e.Graphics,
                              new Rectangle(0, 0, this.Width, this.Height),
                              Color.LightGreen,
                              ButtonBorderStyle.Inset);
      StringFormat sf = new StringFormat();
      sf.FormatFlags = StringFormatFlags.DirectionRightToLeft;
      e.Graphics.DrawString(zeit.ToLongTimeString(),
                            new Font("Courier New", 14, FontStyle.Bold),
                            new SolidBrush(this.ForeColor),
                            (this.Width) + 2, 2,
                            sf);
    }

    public string Zeit
    {
      set
      {
        zeit = DateTime.Parse(value);
        OnZeitChanged(new EventArgs());
      }
      get
      {
        return (zeit.ToLongTimeString());
      }
    }

    public override string Text
    {
      get
      {
        return base.Text;
      }
      set { }
    }

    public event ZeitChangedEventHandler ZeitChanged;

    protected virtual void OnZeitChanged(EventArgs e)
    {
      if (ZeitChanged != null)
        ZeitChanged(this, e);
    }

  }
}