using System;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.IO;

namespace CSharpBuch.Kap28
{
  public partial class Form1: Form
  {
    public Form1()
    {
      InitializeComponent();
    }

    private void btnAnfrage_Click(object sender, EventArgs e)
    {
      Uri uri = new Uri("http://" + txtURI.Text);
      try
      {
        HttpWebRequest request = (HttpWebRequest)WebRequest.Create(uri);
        HttpWebResponse respons = (HttpWebResponse)request.GetResponse();
        txtAntwort.Text = "Antwort von: " + respons.ResponseUri.AbsolutePath + "\nCookies: ";
        foreach(Cookie cookie in respons.Cookies)
            txtAntwort.AppendText(cookie.Name + " = " + cookie.Value);
        txtAntwort.AppendText("\nLnge: " + respons.ContentLength +
                              ", Typ: " + respons.ContentType);                                
        txtAntwort.AppendText("Headers:\n\n" + respons.Headers.ToString()+
                              "\n\n Seiteninhalt:\n\n");
        StreamReader sr = new StreamReader(respons.GetResponseStream(), Encoding.ASCII);
        String s = sr.ReadToEnd();
        txtAntwort.AppendText(s);
        respons.Close();
      }
      catch(WebException ex)
      {
        MessageBox.Show(ex.Message, "Fehler !");
      }
    }
  }
}