using System;
using System.Net;
using System.Net.Sockets;
using System.Text;

namespace CSharpBuch.Kap28
{
  class Client
  {
    static void Main(string[] args)
    {
      ClientStarten();
    }

    public static void ClientStarten()
    {
      int port = 45678;
      int outputB, inputB;
      string inputS;
      byte[] puffer = new byte[256];
      
      Console.Title = "Clientfenster";
      Console.BackgroundColor = ConsoleColor.White;
      Console.ForegroundColor = ConsoleColor.Black;
      Console.Clear();

      IPEndPoint ep = new IPEndPoint(IPAddress.Loopback, port);
      Socket clientSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
      System.Threading.Thread.Sleep(3000);

      try
      {
        clientSocket.Connect(ep);
        Console.WriteLine(">>> Verbindung zu Server " + clientSocket.RemoteEndPoint.ToString() + " hergestellt");
      
        do
        {
          Console.Write("Nachricht an Server: ");
          inputS = Console.ReadLine();
          puffer = Encoding.ASCII.GetBytes(inputS);
          outputB = clientSocket.Send(puffer);
          Console.WriteLine("<<< {0} Bytes an Server gesendet", outputB);
          puffer = new byte[256];
          inputB = clientSocket.Receive(puffer);
          Console.Write(">>> {0} Bytes vom Server empfangen: ", inputB);
          Console.WriteLine(Encoding.ASCII.GetString(puffer, 0, inputB));
        } 
        while(!inputS.Equals("ende") && clientSocket != null);
        
        puffer = Encoding.ASCII.GetBytes("");
        outputB = clientSocket.Send(puffer);
        clientSocket.Shutdown(SocketShutdown.Both);
        clientSocket.Close();
      }
      catch(Exception ex)
      {
        Console.WriteLine(ex.Message);
      }
      Console.WriteLine(">>> Verbindung zum Server geschlossen");
      Console.ReadLine();
    }
  }
}
