using System;
using System.Net;
using System.Windows.Forms;

namespace CSharpBuch.Kap28
{
  public partial class DNS_Form: Form
  {
    public DNS_Form()
    {
      InitializeComponent();
    }

    private void txtIP_Leave(object sender, EventArgs e)
    {
      try
      {
        IPHostEntry he = Dns.GetHostEntry(IPAddress.Parse(txtIP.Text));
        txtAlias.Text = he.HostName;
        txtAliases.Clear();
        foreach(string s in he.Aliases)
          txtAliases.AppendText(s);
      }
      catch(Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void txtAlias_Leave(object sender, EventArgs e)
    {
      IPAddress[] ips = Dns.GetHostAddresses(txtAlias.Text);
      txtIP.Text = ips[0].ToString();

      try
      {
      }
      catch(Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }
  }
}