using System;
using System.Net;
using System.Net.Sockets;
using System.Text;

namespace CSharpBuch.Kap28
{
  class Server
  {
    static void Main(string[] args)
    {
      ServerStarten();
    }

    public static void ServerStarten()
    {
      string inputS;
      int inputB, outputB;
      int port = 45678;
      byte[] puffer = new byte[256];

      Console.Title = "Serverfenster";
      Console.BackgroundColor = ConsoleColor.White;
      Console.ForegroundColor = ConsoleColor.Black;
      Console.Clear();

      IPEndPoint ep = new IPEndPoint(IPAddress.Loopback, port);
      Socket serverSocket = new Socket(AddressFamily.InterNetwork, 
                                       SocketType.Stream, ProtocolType.Tcp);
      serverSocket.Bind(ep);
      serverSocket.Listen(5);
      
      try 
      {
        Console.WriteLine(">>> Server luft");
        Socket socket = serverSocket.Accept();
        Console.WriteLine("--> Client angemeldet");

        while((inputB = socket.Receive(puffer)) != 0)
        {
          inputS = Encoding.ASCII.GetString(puffer, 0, inputB);
          Console.Write(">>> {0} Bytes empfangen: ", inputB);
          Console.WriteLine(inputS);
          puffer = Encoding.ASCII.GetBytes("Server hat " + inputB + " Bytes empfangen\n");
          outputB = socket.Send(puffer);
          Console.Write("<<< {0} Bytes gesendet: ", outputB);
          Console.WriteLine(Encoding.ASCII.GetString(puffer, 0, outputB));
          puffer = new byte[256];
        }

        socket.Shutdown(SocketShutdown.Both);
        socket.Close();
        
        Console.WriteLine(">>> Server geschlossen");
      } 
      catch (Exception ex) 
      {
        Console.WriteLine(ex.Message);
      }
      Console.ReadLine();
    }    
  }
}
