using System;
using System.Windows.Forms;
using System.Net;
using System.IO;

namespace CSharpBuch.Kap28
{
  public partial class Form1: Form
  {
    WebClient wc;
    Uri uri;

    public Form1()
    {
      InitializeComponent();
      wc = new WebClient();
      uri = new Uri(tbURL.Text);
    }

    private void tbURL_Leave(object sender, EventArgs e)
    {
      try
      {
        uri = new Uri(tbURL.Text);
        StreamReader sr = new StreamReader(wc.OpenRead(uri));
        rtbInfos.Text = "";
        String s = sr.ReadToEnd();
          rtbInfos.AppendText(s);
        webBrowser1.Url = uri;
      }
      catch(Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void btnDownload_Click(object sender, EventArgs e)
    {
      try
      {
        saveFileDialog1.FileName = @"C:\Temp\download.html";
        saveFileDialog1.ShowDialog();
        wc.DownloadFile(tbURL.Text, saveFileDialog1.FileName);
        MessageBox.Show("Datei " + saveFileDialog1.FileName + " erfolgreich erstellt");
      }
      catch(Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void btnURI_Click(object sender, EventArgs e)
    {
      //UriBuilder uriB = new UriBuilder("http", "www.firma.de", 8080, "verz/index.htm", "?frage=neu");
      //uri = uriB.Uri;  
      if(uri != null)
        MessageBox.Show("Schema: " + uri.Scheme +
                        "\nAnmeldung : " + uri.UserInfo +
                        "\nDomain: " + uri.Authority +
                        "\nPort: " + uri.Port +
                        "\nPfadangabe: " + uri.AbsolutePath +
                        "\nAnfrage: " + uri.Query, "URL-Analyse");
      else
        MessageBox.Show("keine URI festgelegt");
    }
  }
}