﻿using System;
using System.Reflection;

namespace CSharpBuch.Kap29
{
  class LokaleReflection
  {
    static void Main(string[] args)
    {
      Assembly asbl = Assembly.GetExecutingAssembly();
      Type[] types = asbl.GetTypes();
      foreach (Type t in types)
      {
        Console.WriteLine("Typname: " + t.FullName);
        Console.WriteLine("Modul: " + t.Module.Name);
        Console.WriteLine("Basistyp: " + t.BaseType.Name + "\n");
        Console.WriteLine("Methoden :");
        MethodInfo[] mi = t.GetMethods(BindingFlags.NonPublic | BindingFlags.Static |
                                       BindingFlags.Public | BindingFlags.Instance |
                                       BindingFlags.DeclaredOnly);
        foreach (MethodInfo m in mi)
        {
          Console.WriteLine("  " + m.Name);
          ParameterInfo[] pi = m.GetParameters();
          foreach (ParameterInfo p in pi)
            Console.WriteLine("    " + p.ParameterType.Name + " " + p.Name);
        }
        Console.WriteLine();
      }
      Console.ReadLine();
    }
  }
  public class Mathe
  {
    public int Add(int zahl1, int zahl2)
    {
      return zahl1 + zahl2;
    }
    public int Minus(int zahl1, int zahl2)
    {
      return zahl1 + zahl2;
    }
  }
}
