using System;
using System.Drawing;
using System.Windows.Forms;
using System.Xml;

namespace CSharpBuch.Kap30
{
  public partial class Form1 : Form
  {
    public Form1()
    {
      InitializeComponent();
    }

    private void btnLesen_Click(object sender, EventArgs e)
    {
      XmlDocument document = new XmlDocument();
      XmlNodeList nlist;
      document.Load("Kunden.xml");
      nlist = document.GetElementsByTagName("Kunde");
      foreach (XmlNode kunde in nlist)
      {
        textBox1.AppendText("***** Neuer Kunde *****\r\n");
        foreach(XmlNode kundendaten in kunde.ChildNodes)
          textBox1.AppendText(kundendaten.Name + ": " + kundendaten.InnerText + "\r\n");
        textBox1.AppendText("\r\n\r\n");
      }      
    }

    private void btnSchreiben_Click(object sender, EventArgs e)
    {
      XmlDocument document = new XmlDocument();

      XmlDeclaration decl = document.CreateXmlDeclaration("1.0", "iso-8859-1", "");
      document.AppendChild(decl);
      
      XmlElement elemCDListe = document.CreateElement("CDListe");
      document.AppendChild(elemCDListe); 
      
      XmlElement elemCD = document.CreateElement("CD");
      elemCDListe.AppendChild(elemCD);

      XmlElement elemTitel = document.CreateElement("Titel");
      elemTitel.InnerText = "Back to the Future";
      elemCD.AppendChild(elemTitel);
      XmlElement elemDauer = document.CreateElement("Dauer");
      elemDauer.InnerText = "1:10:00";
      elemCD.AppendChild(elemDauer);      

      document.Save("CDListe.xml");

      textBox1.Text = document.OuterXml;
    }
  }
}