using System;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Schema;

namespace CSharpBuch.Kap30
{
  public partial class frmMain : Form
  {
    public frmMain()
    {
      InitializeComponent();
    }

    private void btnStart_Click(object sender, EventArgs e)
    {
      int einzug = 0;

      XmlReader reader = XmlReader.Create("Kunden.xml");
      while (reader.Read())
      {
        if (reader.NodeType == XmlNodeType.Element)
        {
          String leer = new String(' ', 2 * einzug);
          textBox1.AppendText(leer + "<" + reader.Name + ">\r\n");
          einzug++;
        }

        if (reader.NodeType == XmlNodeType.EndElement)
        {
          einzug--;
          String leer = new String(' ', 2 * einzug);
          textBox1.AppendText(leer + "</" + reader.Name + ">\r\n");
        }
        
        if (reader.NodeType == XmlNodeType.Attribute)
          textBox1.AppendText(" " + reader.Name + "=" + reader.Value + ">\r\n");

        if (reader.NodeType == XmlNodeType.Text)
        {
          String leer = new String(' ', 2 * einzug);
          textBox1.AppendText(leer + reader.Value + "\r\n");
        }
      }
      reader.Close();
    }

    private void button1_Click(object sender, EventArgs e)
    {
      XmlReaderSettings set = new XmlReaderSettings();
      set.ValidationType = ValidationType.Schema;
      set.Schemas.Add(null, "Kunden.xsd");
      set.ValidationEventHandler += new ValidationEventHandler(KundenValidationEventHandler);

      XmlReader reader = XmlReader.Create("KundenF.xml", set);
      while (reader.Read())
        ;
      reader.Close();
    }
    private void KundenValidationEventHandler(object sender, ValidationEventArgs e)
    {
      textBox1.AppendText("Validation-Fehler >>> " + e.Message + "\r\n\r\n");
    }
  }
}