﻿using System;
using System.Windows.Forms;

namespace CSharpBuch.Kap25
{
  public class NumerischeTextBox: TextBox
  {
    public NumerischeTextBox()
    {
      base.KeyPress += new KeyPressEventHandler(NumKeyPress);
    }

    public void NumKeyPress(object sender, KeyPressEventArgs e)
    {
      try
      {
        if (e.KeyChar < 32) 
          return;
        Convert.ToDouble(this.Text + e.KeyChar);
      }
      catch (FormatException fe)
      {
        MessageBox.Show(fe.Message);
        e.Handled = true;
      }
    }
  }
}