﻿using System;
using System.Windows.Forms;
using System.Drawing;
using System.ComponentModel;

namespace CSharpBuch.Kap25
{
  public class Wecker:Control
  {
    DateTime zeit, stopZeit;
    Timer t;
    bool piep;
    string meldung;

    public Wecker()
    {
      init();
      stopZeit = DateTime.Parse("0:0:0");
      meldung = "Alarm";
    }

    public Wecker(String stop, string meldung)
    {
      stopZeit = DateTime.Parse(stop);
      this.meldung = meldung;
      init();
    }

    private void init()
    {
      this.BackColor = Color.LightBlue;
      this.ForeColor = Color.Blue;
      this.MinimumSize = new Size(240, 23);
      this.MaximumSize = new Size(240, 23);
      zeit = DateTime.Now;
      piep = false;
      t = new Timer();
      t.Interval = 1000;
      t.Tick += new System.EventHandler(this.t_Tick);
      t.Start();
    }

    new void Dispose()
    {
      base.Dispose();
      t.Stop();
    }

    private void t_Tick(object sender, EventArgs e)
    {
      zeit = zeit.AddSeconds(1);
      OnZeitChanged(new EventArgs());
      this.Refresh();
      if (zeit.ToLongTimeString() == stopZeit.ToLongTimeString())
      {
        OnAlarm(new EventArgs());
        piep = true;
        if (MessageBox.Show(meldung) == DialogResult.OK)
          piep = false;
      }
      if (piep)
        System.Media.SystemSounds.Beep.Play();
    }

    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      ControlPaint.DrawBorder(e.Graphics,
                              new Rectangle(0, 0, this.Width, this.Height),
                              Color.Blue,
                              ButtonBorderStyle.Inset);
      int s = stopZeit.Second - zeit.Second;
      int m = stopZeit.Minute - zeit.Minute;
      int h = stopZeit.Hour - zeit.Hour;
      if (s < 0)
      {
        s = 60 + s;
        m = m - 1;
      }
      if (m < 0)
      {
        m = 60 + m;
        h = h - 1;
      }
      if (h < 0)
        h = 24 + h;
      string hh = h >= 10 ? "" + h : "0" + h;
      string mm = m >= 10 ? "" + m : "0" + m;
      string ss = s >= 10 ? "" + s : "0" + s;
      string zeitDiff = "" + hh + ":" + mm + ":" + ss;
      StringFormat sf = new StringFormat();
      sf.FormatFlags = StringFormatFlags.DirectionRightToLeft;
      e.Graphics.DrawString("Bis zum Alarm: " + zeitDiff,
                            new Font("Courier New", 12, FontStyle.Regular),
                            new SolidBrush(this.ForeColor),
                            (this.Width) + 2, 2,
                            sf);
    }

    [Category("Daten"), Description("Zeit zu der der Wecker klingeln soll")]
    public string StopZeit
    {
      set
      {
        stopZeit = DateTime.Parse(value);
        OnZeitChanged(new EventArgs());
      }
      get
      {
        return (stopZeit.ToLongTimeString());
      }
    }

    [Category("Geänderte Eigenschaft"), Description("Tritt ein, wenn die Weckzeit geändert wird")]
    public event ZeitChangedEventHandler ZeitChanged;
    public delegate void ZeitChangedEventHandler(object sender, EventArgs e);


    protected virtual void OnZeitChanged(EventArgs e)
    {
      if (ZeitChanged != null)
        ZeitChanged(this, e);
    }

    [Category("Aktion"), Description("Tritt ein, wenn die Weckzeit erreicht ist")]
    public event AlarmEventHandler Alarm;
    public delegate void AlarmEventHandler(object sender, EventArgs e);

    protected virtual void OnAlarm(EventArgs e)
    {
      if (Alarm != null)
        Alarm(this, e);
    }
  }
}