﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Text;

namespace CSharpBuch.Kap28
{
  class ServerProgram
  {
    static void Main(string[] args)
    {
      ClientStarten();
    }

    public static void ClientStarten()
    {
      Console.Title = "Clientfenster";
      Console.BackgroundColor = ConsoleColor.White;
      Console.ForegroundColor = ConsoleColor.Black;
      Console.Clear();
      int port = 45678;
      int outputB, inputB;
      string inputS;
      byte[] puffer = new byte[256];
      IPEndPoint ep = new IPEndPoint(IPAddress.Loopback, port);
      Socket clientSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
      try
      {
        clientSocket.Connect(ep);
        Console.WriteLine("<<< Verbindung zu Server " +
                          clientSocket.RemoteEndPoint.ToString() + " hergestellt >>>");
        Console.Write("<<<Nachricht: ");
        while(((inputS = Console.ReadLine())!= "") && (clientSocket != null))
        {
          puffer = Encoding.ASCII.GetBytes(inputS);
          outputB = clientSocket.Send(puffer);
          puffer = new byte[256];
          inputB = clientSocket.Receive(puffer);
          inputS = Encoding.ASCII.GetString(puffer, 0, inputB);
          Console.WriteLine("Server>>> {0}", inputS);
          Console.Write("<<<Nachricht: ");
        } 
        puffer = Encoding.ASCII.GetBytes("");
        outputB = clientSocket.Send(puffer);
        clientSocket.Shutdown(SocketShutdown.Both);
        clientSocket.Close();
      }
      catch(Exception ex)
      {
        Console.WriteLine("Fehler aufgetreten:" + ex.Message);
      }
      Console.WriteLine(">>> Verbindung zum Server geschlossen");
      Console.ReadLine();
    }
  }
}
