﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Text;

namespace CSharpBuch.Kap28
{
  class ServerProgram
  {
    static void Main(string[] args)
    {
      ServerStarten();
    }
    public static void ServerStarten()
    {
      Console.Title = "Serverfenster";
      Console.BackgroundColor = ConsoleColor.White;
      Console.ForegroundColor = ConsoleColor.Black;
      Console.Clear();
      string inputS, outputS;
      int inputB, outputB;
      int port = 45678;
      byte[] puffer = new byte[256];
      IPEndPoint ep = new IPEndPoint(IPAddress.Loopback, port);
      Socket serverSocket = new Socket(AddressFamily.InterNetwork,
                                       SocketType.Stream, ProtocolType.Tcp);
      serverSocket.Bind(ep);
      serverSocket.Listen(10);
      Console.WriteLine(">>> Server läuft");
      
      while(true)
      {
        try
        {
          Socket socket = serverSocket.Accept();
          Console.WriteLine("--> Client angemeldet");
          while((inputB = socket.Receive(puffer)) != 0)
          {
            inputS = Encoding.ASCII.GetString(puffer, 0, inputB);
            Console.Write("Client>>> {0}\n<<<Antwort: ", inputS);
            outputS = Console.ReadLine();
            puffer = Encoding.ASCII.GetBytes(outputS);
            outputB = socket.Send(puffer);
            puffer = new byte[256];
          }
          socket.Shutdown(SocketShutdown.Both);
          socket.Close();
          Console.WriteLine("--> Client abgemeldet");
        }

        catch(Exception ex)
        {
          Console.WriteLine("Fehler aufgetreten: " + ex.Message);
        }
      }
    }
  }
}
